#!/bin/bash

# تاریخ فعلی
current_date=$(date '+%Y-%m-%d %H:%M:%S')

# فایل خروجی
output_file="insert_files.sql"

# پاک کردن فایل قبلی
> "$output_file"

echo "-- SQL Insert برای فایل‌های MP3" >> "$output_file"
echo "-- تاریخ تولید: $current_date" >> "$output_file"
echo "" >> "$output_file"

# شمارنده
count=0

# حلقه برای تمام فایل‌های mp3
for file in *.mp3; do
    # چک کردن اگر فایل واقعا وجود داره
    if [ ! -f "$file" ]; then
        continue
    fi
    
    # نام بدون پسوند
    name="${file%.mp3}"
    
    # فرار از کاراکترهای خاص برای SQL
    file_escaped="${file//\'/\\\'}"
    name_escaped="${name//\'/\\\'}"
    
    # URL فایل
    file_url="https://fanoos-maaref.ir/wp-content/uploads/1404/${file_escaped}"
    
    # تولید کوئری INSERT
    cat >> "$output_file" << EOF
INSERT INTO \`fatemiehasdEEP_posts\` (
    \`post_content\`,
    \`post_title\`,
    \`post_excerpt\`,
    \`post_status\`,
    \`comment_status\`,
    \`ping_status\`,
    \`post_password\`,
    \`post_name\`,
    \`to_ping\`,
    \`pinged\`,
    \`post_modified\`,
    \`post_modified_gmt\`,
    \`post_content_filtered\`,
    \`post_parent\`,
    \`guid\`,
    \`menu_order\`,
    \`post_type\`,
    \`post_mime_type\`,
    \`comment_count\`
) VALUES (
    '',
    '${name_escaped}',
    '',
    'inherit',
    'open',
    'closed',
    '',
    '${name_escaped}',
    '',
    '',
    '${current_date}',
    '${current_date}',
    '',
    6,
    '${file_url}',
    0,
    'attachment',
    'audio/mpeg',
    0
);

EOF
    
    ((count++))
done

echo "-- تعداد کل: $count فایل" >> "$output_file"

echo "✓ تولید شد: $output_file"
echo "✓ تعداد فایل‌ها: $count"
echo ""
echo "برای اجرای کوئری:"
echo "mysql -u username -p database_name < $output_file"
